using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Borland.Eco.Handles;
using Borland.Eco.Windows.Forms;
using Borland.Eco.WinForm;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;

namespace AssociationClassDemo
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Borland.Eco.Handles.ReferenceHandle rhRoot;
		private Borland.Eco.WinForm.EcoActionExtender EcoGlobalActions;
		private Borland.Eco.WinForm.EcoDragDropExtender EcoDragDrop;
		private Borland.Eco.WinForm.EcoAutoFormExtender EcoAutoForms;
		private Borland.Eco.WinForm.EcoListActionExtender EcoListActions;
		private AssociationClassDemoEcoSpace m_EcoSpace;
		private Borland.Eco.Handles.ExpressionHandle ehAllGroups;
		private System.Windows.Forms.DataGrid dgAllGroups;
		private System.Windows.Forms.Button btnCreateGroup;
		private Borland.Eco.Handles.ExpressionHandle ehMembers;
		private System.Windows.Forms.DataGrid dgMembers;
		private Borland.Eco.Handles.ExpressionHandle ehParticipations;
		private System.Windows.Forms.DataGrid dgParticipations;
		private System.Windows.Forms.Button btnAddMember;
		private System.Windows.Forms.Button btnMoveDown;
		private System.Windows.Forms.Button btnMoveUp;
		private Borland.Eco.Handles.CurrencyManagerHandle cmAllGroups;
		public AssociationClassDemoEcoSpace EcoSpace
		{
			get { return m_EcoSpace; }
		}

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			m_EcoSpace = new AssociationClassDemoEcoSpace();
			rhRoot.EcoSpace = m_EcoSpace;
			// The line below will automatically activate the ECO Space on form creation.
			// Remove the line if you wish to activate the EcoSpace manually
			m_EcoSpace.Active = true;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			Borland.Eco.Handles.OclColumn oclColumn11 = new Borland.Eco.Handles.OclColumn();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.EcoListActions = new Borland.Eco.WinForm.EcoListActionExtender();
			this.EcoDragDrop = new Borland.Eco.WinForm.EcoDragDropExtender();
			this.EcoGlobalActions = new Borland.Eco.WinForm.EcoActionExtender();
			this.EcoAutoForms = new Borland.Eco.WinForm.EcoAutoFormExtender();
			this.dgAllGroups = new System.Windows.Forms.DataGrid();
			this.ehAllGroups = new Borland.Eco.Handles.ExpressionHandle();
			this.dgMembers = new System.Windows.Forms.DataGrid();
			this.ehMembers = new Borland.Eco.Handles.ExpressionHandle();
			this.cmAllGroups = new Borland.Eco.Handles.CurrencyManagerHandle();
			this.dgParticipations = new System.Windows.Forms.DataGrid();
			this.ehParticipations = new Borland.Eco.Handles.ExpressionHandle();
			this.btnCreateGroup = new System.Windows.Forms.Button();
			this.btnAddMember = new System.Windows.Forms.Button();
			this.btnMoveDown = new System.Windows.Forms.Button();
			this.btnMoveUp = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.dgAllGroups)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dgMembers)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.dgParticipations)).BeginInit();
			this.SuspendLayout();
			// 
			// EcoGlobalActions
			// 
			this.EcoGlobalActions.RootHandle = this.rhRoot;
			// 
			// dgAllGroups
			// 
			this.dgAllGroups.CaptionText = "All groups";
			this.dgAllGroups.DataMember = "";
			this.dgAllGroups.DataSource = this.ehAllGroups;
			this.EcoAutoForms.SetEcoAutoForm(this.dgAllGroups, true);
			this.dgAllGroups.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgAllGroups.Location = new System.Drawing.Point(8, 8);
			this.dgAllGroups.Name = "dgAllGroups";
			this.dgAllGroups.Size = new System.Drawing.Size(208, 144);
			this.dgAllGroups.TabIndex = 0;
			// 
			// ehAllGroups
			// 
			oclColumn11.Expression = "self.Participation->size";
			oclColumn11.Name = "participationsize";
			this.ehAllGroups.Columns.AddRange(new Borland.Eco.Handles.AbstractColumn[] {
						oclColumn11});
			this.ehAllGroups.Expression = "Group.allInstances";
			this.ehAllGroups.RootHandle = this.rhRoot;
			// 
			// dgMembers
			// 
			this.dgMembers.CaptionText = "Group members";
			this.dgMembers.DataMember = "";
			this.dgMembers.DataSource = this.ehMembers;
			this.EcoAutoForms.SetEcoAutoForm(this.dgMembers, true);
			this.dgMembers.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgMembers.Location = new System.Drawing.Point(224, 8);
			this.dgMembers.Name = "dgMembers";
			this.dgMembers.Size = new System.Drawing.Size(144, 144);
			this.dgMembers.TabIndex = 3;
			// 
			// ehMembers
			// 
			this.ehMembers.Expression = "self.Member";
			this.ehMembers.RootHandle = this.cmAllGroups;
			// 
			// cmAllGroups
			// 
			this.cmAllGroups.BindingContext = this.dgAllGroups;
			this.cmAllGroups.RootHandle = this.ehAllGroups;
			// 
			// dgParticipations
			// 
			this.dgParticipations.CaptionText = "Participation objects (association class)";
			this.dgParticipations.DataMember = "";
			this.dgParticipations.DataSource = this.ehParticipations;
			this.EcoAutoForms.SetEcoAutoForm(this.dgParticipations, true);
			this.dgParticipations.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.dgParticipations.Location = new System.Drawing.Point(376, 8);
			this.dgParticipations.Name = "dgParticipations";
			this.dgParticipations.Size = new System.Drawing.Size(288, 144);
			this.dgParticipations.TabIndex = 4;
			// 
			// ehParticipations
			// 
			this.ehParticipations.Expression = "self.Participation";
			this.ehParticipations.RootHandle = this.cmAllGroups;
			// 
			// btnCreateGroup
			// 
			this.btnCreateGroup.Location = new System.Drawing.Point(8, 160);
			this.btnCreateGroup.Name = "btnCreateGroup";
			this.btnCreateGroup.Size = new System.Drawing.Size(112, 23);
			this.btnCreateGroup.TabIndex = 1;
			this.btnCreateGroup.Text = "Create new group";
			this.btnCreateGroup.Click += new System.EventHandler(this.btnCreateGroup_Click);
			// 
			// btnAddMember
			// 
			this.btnAddMember.Location = new System.Drawing.Point(128, 160);
			this.btnAddMember.Name = "btnAddMember";
			this.btnAddMember.Size = new System.Drawing.Size(88, 23);
			this.btnAddMember.TabIndex = 5;
			this.btnAddMember.Text = "Add member";
			this.btnAddMember.Click += new System.EventHandler(this.btnAddMember_Click);
			// 
			// btnMoveDown
			// 
			this.btnMoveDown.Location = new System.Drawing.Point(224, 160);
			this.btnMoveDown.Name = "btnMoveDown";
			this.btnMoveDown.Size = new System.Drawing.Size(72, 23);
			this.btnMoveDown.TabIndex = 6;
			this.btnMoveDown.Text = "Move down";
			this.btnMoveDown.Click += new System.EventHandler(this.btnMoveDown_Click);
			// 
			// btnMoveUp
			// 
			this.btnMoveUp.Location = new System.Drawing.Point(304, 160);
			this.btnMoveUp.Name = "btnMoveUp";
			this.btnMoveUp.Size = new System.Drawing.Size(64, 23);
			this.btnMoveUp.TabIndex = 7;
			this.btnMoveUp.Text = "Move up";
			this.btnMoveUp.Click += new System.EventHandler(this.btnMoveUp_Click);
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(672, 190);
			this.Controls.Add(this.btnMoveUp);
			this.Controls.Add(this.btnMoveDown);
			this.Controls.Add(this.btnAddMember);
			this.Controls.Add(this.dgParticipations);
			this.Controls.Add(this.dgMembers);
			this.Controls.Add(this.btnCreateGroup);
			this.Controls.Add(this.dgAllGroups);
			this.MaximizeBox = false;
			this.MaximumSize = new System.Drawing.Size(680, 224);
			this.MinimumSize = new System.Drawing.Size(680, 224);
			this.Name = "WinForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "Association class demo";
			((System.ComponentModel.ISupportInitialize)(this.dgAllGroups)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dgMembers)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.dgParticipations)).EndInit();
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		[STAThread]
		static void Main()
		{
			WinFormDequeuer.Active = true;
			Application.Run(new WinForm());
		}

		private Random rand = new Random();

		///<summary>
		///Get the currently selected group in the Group grid.
		///</summary>
		private Group GetCurrentGroup()
		{
			Group res = CurrencyManagerHandle.CurrentElement(ehAllGroups, dgAllGroups).AsObject as Group;
			if (res == null)
				throw new Exception("No group selected");
			return res;
		}

		///<summary>
		///Reorder the members of the group.
		///</summary>
		private void btnMoveUp_Click(object sender, System.EventArgs e)
		{
			Group g = GetCurrentGroup();
			int pos = dgMembers.CurrentRowIndex;
			if (pos > 0)
			{
				Member m = g.Member[pos];
				// inserting an object that is already in the list
				// will cause it to move if (and only if) the list
				// is ordered
				g.Member.Insert(pos - 1, m);
				dgMembers.CurrentRowIndex = pos - 1;
			}
		}

		///<summary>
		///Reorder the members of the group.
		///</summary>
		private void btnMoveDown_Click(object sender, System.EventArgs e)
		{
			Group g = GetCurrentGroup();

			int pos = dgMembers.CurrentRowIndex;
			if (pos < g.Member.Count - 1)
			{
				Member m = g.Member[pos];
				MessageBox.Show(m.Name);
				// inserting an object that is already in the list
				// will cause it to move if (and only if) the list
				// is ordered
				g.Member.Insert(pos + 1, m);
				dgMembers.CurrentRowIndex = pos + 1;
			}
		}

		///<summary>
		///Create a new member, give a random name and a random unknown role
		///when adding new member to the current group.
		///</summary>
		private void btnAddMember_Click(object sender, System.EventArgs e)
		{
			Group g = GetCurrentGroup();
			Member m = new Member(EcoSpace);
			m.Name = "<NoName" + rand.Next(1000).ToString() + ">";
			int newpos = g.Member.Add(m);  // this should be identical to g.Member.Count-1
			Participation p = g.Participation[newpos] as Participation;
			p.Role = "<unknown" + rand.Next(1000).ToString() + ">";
		}

		///<summary>
		///Create a new group. Also create a new Member and add to the Group's member-list.
		///Set the Role of the new member to be R&amp;D engineer.
		///</summary>
		private void btnCreateGroup_Click(object sender, System.EventArgs e)
		{
			Group g = new Group(EcoSpace);
			Member m = new Member(EcoSpace);
			g.Name = "EcoTeam";
			m.Name = "Jonas";
			g.Member.Add(m);
			// extract the link object and set the Role-property
			Participation p = g.Participation[0] as Participation;
			p.Role = "R&D Engineer";
		}
	}
}
